unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, LconvEncoding, LCLProc;

type

  { TForm1 }

  TForm1 = class(TForm)
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure Memo1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure CyrillicSearch;

  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2;
{ TForm1 }

procedure TForm1.CyrillicSearch;
var
  k: integer;
  text_Area: string;
begin
  text_Area:= UTF8Copy(UTF8Decode(Memo1.Text), Memo1.SelStart + 1 +
              Memo1.SelLength, UTF8Length(UTF8Decode(Memo1.Text)) -
              Memo1.SelStart - Memo1.SelLength);
  k:= UTF8Pos(str_Search, text_Area);
  if k > 0 then
  begin
    Memo1.SetFocus;
    Memo1.SelStart:= Memo1.SelStart +
                     Memo1.SelLength + k - 1;
    Memo1.SelLength:= UTF8Length(str_Search);
  end
  else
  begin
    ShowMessage('Строка не найдена');
    Memo1.SelStart:= 0;
    Memo1.SelLength:= 0;
  end;
end;

procedure TForm1.Memo1KeyDown(Sender: TObject;
                              var Key: Word;
                              Shift: TShiftState);
begin
  if((Key = ord('F')) and (ssCTRL in Shift)) then
  begin
    Memo1.SelStart:= 0;
    Memo1.SelLength:= 0;
    Form2.ShowModal;
   end
  else
  if Key = 114 then   // десятичный код клавиши F3
     CyrillicSearch;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  tfile: TStringList;
  str: string;
begin
  tfile:= TStringList.Create;
  tfile.LoadFromFile('File in Russian.txt');
  str:= tfile.Text;
  {$IFDEF WINDOWS}
    str:= SysToUTF8(str); // преобразование в кодировку UTF-8
  {$ENDIF}
  Memo1.Lines.Add(str);
  tfile.Free;
end;

initialization
  {$I unit1.lrs}

end.

